const Sequelize = require('sequelize');
module.exports = function(sequelize, DataTypes) {
  return sequelize.define('tbl_batchsummary_detail2_Coating', {
    SerNo: {
      autoIncrement: true,
      type: DataTypes.INTEGER,
      allowNull: false,
      primaryKey: true
    },
    RepSerNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    RecSeqNo: {
      type: DataTypes.INTEGER,
      allowNull: true
    },
    Date: {
      type: DataTypes.DATEONLY,
      allowNull: true
    },
    Time: {
      type: DataTypes.TIME,
      allowNull: true
    },
    InstrumentID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    Avg: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    TestResult: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserID: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    UserName: {
      type: DataTypes.STRING(200),
      allowNull: true
    },
    NoOfSample: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    EndTime: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    StartTime: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    SprayPeriod: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    MesTestType: {
      type: DataTypes.STRING(50),
      allowNull: true
    },
    DataValue: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    DataValue1: {
      type: DataTypes.STRING(100),
      allowNull: true
    },
    DataValue2: {
      type: DataTypes.STRING(100),
      allowNull: true
    }
  }, {
    sequelize,
    tableName: 'tbl_batchsummary_detail2_Coating',
    schema: 'dbo',
    timestamps: false,
    indexes: [
      {
        name: "PK_tbl_batchsummary_detail2_Coating_SerNo",
        unique: true,
        fields: [
          { name: "SerNo" },
        ]
      },
    ]
  });
};
